/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.updaterupdater;

import at.chaosfield.updaterupdater.UpdaterClassLoader;
import at.chaosfield.updaterupdater.api.PackUpdateClassLoader;
import at.chaosfield.updaterupdater.api.UpdaterAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdaterUpdater {
    public static final String PROJECT_NAME = "PackUpdateUpdater";

    public static void main(String[] stringArray) {
        try {
            new UpdaterUpdater().run(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getOwnVersion() throws IOException {
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            Manifest manifest = new Manifest(uRL.openStream());
            String string = manifest.getMainAttributes().getValue("Implementation-Title");
            if (string == null || !string.equals(PROJECT_NAME)) continue;
            return manifest.getMainAttributes().getValue("Implementation-Version");
        }
        return "Unknown";
    }

    public void run(String[] stringArray) throws IOException {
        Object object;
        Object object2;
        File file;
        File file2;
        String string = this.getOwnVersion();
        System.out.println("PackUpdateUpdater Version: " + string);
        String string2 = null;
        String string3 = ".";
        if (stringArray.length > 0 && stringArray[0].equals("client")) {
            string3 = System.getenv("INST_MC_DIR");
        }
        if (string3 == null) {
            System.err.println("This program is intended to run as MultiMC Pre-Launch Hook");
            System.exit(1);
        }
        if (!(file2 = new File(file = new File(string3), "packupdate")).exists() && !file2.mkdirs()) {
            System.err.println("Could not create packupdate data directory");
        }
        File file3 = new File(file2, "PackUpdate.jar");
        File file4 = new File(file2, "updater.properties");
        Properties properties = new Properties();
        properties.setProperty("beta", "false");
        properties.setProperty("forceVersion", "");
        properties.setProperty("apiUrl", "https://api.github.com/repos/XDjackieXD/PackUpdate/releases");
        try {
            if (file4.exists()) {
                properties.load(new FileReader(file4));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Could not read settings, exiting");
        }
        boolean bl = properties.getProperty("beta").equalsIgnoreCase("true");
        String string4 = properties.getProperty("forceVersion");
        URL uRL = new URL(properties.getProperty("apiUrl"));
        if (string4.equals("")) {
            string4 = null;
        }
        try {
            if (file3.exists()) {
                object2 = new JarFile(file3).getManifest();
                string2 = ((Manifest)object2).getMainAttributes().getValue("Implementation-Version");
            }
        }
        catch (IOException iOException) {
            System.out.println("[PackUpdate Updater] Warning: could not find original PackUpdate. Downloading it now.");
        }
        try {
            if (string2 == null || UpdaterUpdater.hasUpdate(string2, bl, string4, uRL)) {
                System.out.println("PackUpdate Update available, downloading...");
                if (!UpdaterUpdater.downloadPackUpdate(file3.getPath(), bl, string4, uRL)) {
                    System.err.println("[PackUpdate Updater] Update Failed.");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("[PackUpdate Updater] Update Failed.");
            iOException.printStackTrace();
        }
        try {
            properties.store(new FileWriter(file4), "PackUpdate Updater settings");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Could not store properties");
        }
        object2 = null;
        try {
            if (file3.exists()) {
                object = new JarFile(file3).getManifest();
                object2 = ((Manifest)object).getMainAttributes().getValue("Main-Class");
                if (object2 == null) {
                    System.err.println("[PackUpdate Updater] Downloaded packupdate jar lacks main class. Can't continue.");
                    System.exit(1);
                }
            } else {
                System.err.println("[PackUpdate Updater] Could not find the file i just downloaded. Refusing to perform.");
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("[PackUpdate Updater] Everything is broken, call for help!");
            System.exit(1);
        }
        try {
            object = new UpdaterClassLoader();
            UpdaterAPI.setClassLoader((PackUpdateClassLoader)object);
            ((UpdaterClassLoader)object).addURL(file3.toURI().toURL());
            Method method = ((ClassLoader)object).loadClass((String)object2).getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            System.out.println("[PackUpdate Updater] Execution of PackUpdater failed");
            exception.printStackTrace();
        }
    }

    public static JSONObject getReleaseForBranch(boolean bl, String string, URL uRL) throws IOException {
        JSONArray jSONArray = UpdaterUpdater.getJSON(uRL);
        for (Object object : jSONArray) {
            JSONObject jSONObject = (JSONObject)object;
            if (!(string == null ? !jSONObject.getBoolean("draft") && (bl || !jSONObject.getBoolean("prerelease")) : jSONObject.getString("tag_name").equals(string))) continue;
            return jSONObject;
        }
        throw new RuntimeException(String.format("[PackUpdate Updater] No release found - channel: %s, force_version: %s \n", bl ? "beta" : "stable", string == null ? "none" : string));
    }

    public static boolean hasUpdate(String string, boolean bl, String string2, URL uRL) throws IOException {
        if (string2 != null) {
            return !string2.equals(string);
        }
        JSONObject jSONObject = UpdaterUpdater.getReleaseForBranch(bl, null, uRL);
        return !jSONObject.get("tag_name").equals(string);
    }

    public static boolean downloadPackUpdate(String string, boolean bl, String string2, URL uRL) throws IOException {
        JSONObject jSONObject = UpdaterUpdater.getReleaseForBranch(bl, string2, uRL);
        for (Object object : jSONObject.getJSONArray("assets")) {
            if (!((JSONObject)object).getString("name").startsWith("PackUpdate")) continue;
            FileUtils.copyURLToFile(new URL(((JSONObject)object).getString("browser_download_url")), new File(string));
            if (UpdaterUpdater.getLength(string) != ((JSONObject)object).getLong("size")) continue;
            return true;
        }
        return false;
    }

    private static JSONArray getJSON(URL uRL) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new BufferedReader(new InputStreamReader(uRL.openStream())));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        return new JSONArray(stringBuilder.toString());
    }

    public static long getLength(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }
}

